import matplotlib.pyplot as plt
import numpy as np
import seaborn as sns
from model import datatable
from regressions import random_forest, knn_regression, decision_tree, logistic_regression, svm_classification, \
    nbayes_classification
from sklearn import metrics
from sklearn.metrics import classification_report, confusion_matrix, f1_score, ConfusionMatrixDisplay
from sklearn.preprocessing import StandardScaler
import pandas as pd


def plotter():
    evaluations = []
    evaluations_r = []
    df = cleaning()
    fig, ax = plt.subplots(figsize=(40, 40))
    sns.heatmap(df.corr(), annot=True, cmap='Blues', ax=ax)
    plt.show()
    y_test, y_pred = random_forest(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('Random Forest', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "Random Forest")
    y_test, y_pred = knn_regression(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('KNN', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "KNN")
    y_test, y_pred = decision_tree(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('Decision Tree', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "Decision Tree")
    y_test, y_pred = logistic_regression(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('Logistic Regression', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "Logistic Regression")
    y_test, y_pred = svm_classification(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('SVM', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "SVM")
    y_test, y_pred = nbayes_classification(df)
    cm = confusion_matrix(y_test, y_pred, labels=[0, 1])
    disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=[0, 1])
    plot('Naive Bayes', disp)
    evaluations, evaluations_r = evaluator(y_test, y_pred, evaluations, evaluations_r, "Naive Bayes")
    final_evaluation(evaluations, "Accuracy", "Green")
    final_evaluation(evaluations_r, "F1", "Purple")
    g = sns.pairplot(df, hue='tool_condition', vars=["feedrate", "clamp_pressure"])
    g.fig.suptitle("Tool Condition - feedrate/clamp pressure", y=1.1, fontsize=20)
    g.fig.set_figheight(6)
    g.fig.set_figwidth(9)
    plt.show()


def plot(z, k):
    k.plot()
    k.ax_.set_title(z)
    plt.show()


def cleaning():
    df = datatable()
    to_drop = []
    for col in df.columns:
        if len(df[col].unique()) == 1:
            to_drop.append(col)
    df.drop(to_drop, axis=1, inplace=True)
    cols_to_norm = ['X1_ActualPosition', 'X1_ActualVelocity', 'X1_ActualAcceleration', 'X1_CommandPosition',
                    'X1_CommandVelocity', 'X1_CommandAcceleration', 'X1_CurrentFeedback', 'X1_DCBusVoltage',
                    'X1_OutputCurrent', 'X1_OutputVoltage', 'X1_OutputPower', 'Y1_ActualPosition', 'Y1_ActualVelocity',
                    'Y1_ActualAcceleration', 'Y1_CommandPosition', 'Y1_CommandVelocity', 'Y1_CommandAcceleration',
                    'Y1_CurrentFeedback', 'Y1_DCBusVoltage', 'Y1_OutputCurrent', 'Y1_OutputVoltage', 'Y1_OutputPower',
                    'Z1_ActualPosition', 'Z1_ActualVelocity', 'Z1_ActualAcceleration', 'Z1_CommandPosition',
                    'Z1_CommandVelocity', 'Z1_CommandAcceleration',
                    'S1_ActualPosition', 'S1_ActualVelocity',
                    'S1_ActualAcceleration', 'S1_CommandPosition', 'S1_CommandVelocity', 'S1_CommandAcceleration',
                    'S1_CurrentFeedback', 'S1_DCBusVoltage', 'S1_OutputCurrent', 'S1_OutputVoltage', 'S1_OutputPower',
                    'M1_CURRENT_PROGRAM_NUMBER', 'M1_sequence_number', 'M1_CURRENT_FEEDRATE',
                    'Machining_Process', 'exp_num', 'feedrate', 'clamp_pressure',
                    'machining_finalized', 'passed_visual_inspection']
    df[cols_to_norm] = StandardScaler().fit_transform(df[cols_to_norm])
    df.dropna(axis=0, how="any", subset=['tool_condition'], inplace=True)
    df = df.fillna("", inplace=False)
    print(df)
    labels = ['not worn', 'worn']
    count = df['tool_condition'].value_counts()[0]
    print(count)
    count2 = df['tool_condition'].value_counts()[1]
    print(count2)
    df['tool_condition'].value_counts().plot(kind='pie', labels=labels)
    return df


def evaluator(y_test, y_pred, evaluations, evaluations_r, method):
    precision = metrics.precision_score(y_test, y_pred)
    accuracy = metrics.accuracy_score(y_test, y_pred)
    recall = metrics.recall_score(y_test, y_pred)
    f1 = metrics.f1_score(y_test, y_pred)
    print(pd.DataFrame([precision, accuracy, recall, f1], index=['Precision', 'Accuracy', 'Recall', 'F1'],
                       columns=[method]))
    evaluations.append(accuracy)
    evaluations_r.append(f1)
    return evaluations, evaluations_r


def final_evaluation(evaluations, method, color):
    data = {'Random Forest': evaluations[0], 'KNN': evaluations[1],
            'Decision Tree': evaluations[2], 'Logistic Regression': evaluations[3], 'SVM': evaluations[4],
            'Naive Bayes': evaluations[5]}
    Names = list(data.keys())
    values = list(data.values())
    fig = plt.figure(figsize=(10, 5))
    plt.bar(Names, values, color=color,
            width=0.4)
    plt.xlabel("Methods")
    plt.ylabel(method)
    plt.title("Evaluation of the methods selected")
    plt.show()
